{*
 * Projecte Fressa a LINKAT
 * GLOBUS3
 *
 * @author Jordi Lagares Roset "jlagares@xtec.cat - www.lagares.org"
 * amb el suport del Departament d'Educacio de la Generalitat de Catalunya
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details (see the LICENSE file).
 *}

{******************************************************************}
{ Unit Entrada de So. 8/16 bits 11025/22050/44100 mostreig         }
{ Obre el WaveIn i va retornant el valor mxim del so              }
{ data inici 30/09/04                                              }
{ ltim dia  11/10/04                                              }
{******************************************************************}

{
Com funciona?

-Al principi cal cridar a la procedure:

    IniciarDadesEntradaDeSo;


-Quant es vulgui detectar el mxim cal cridar a la function:
-Donant el Handle de la finestra i el nombre de bytes del Buffer que ha d'sser ms petit que MaximBytesBuffer (8196)

    EngegarProcesEntradaDeSo(HWindow:HWnd):integer;


-Cal definir una funci en el programa origen de la segent forma:

    procedure WMWIMDATA(var Msg: TMessage);virtual wm_First + MM_WIM_DATA;
    var
      ValorMaxim:integer;
    begin
      if ParoProcesContinuEntradaDeSo then exit;
      ValorMaxim:=ValorMaximDetectatEntradaDeSo;
    end;


-Per parar el procs cal cridar a la function:

    PararEntradaDeSo;


-Al final cal cridar al procedure:

    FinalitzarEntradaDeSo;

}

Unit UnitEntradaDeSo;

{************************************************}
interface
{************************************************}

uses Windows;

Procedure IniciarDadesEntradaDeSo;
function EngegarProcesEntradaDeSo(HWindow:HWnd):integer;
function ValorMaximDetectatEntradaDeSo:integer;
procedure PararEntradaDeSo;
procedure FinalitzarEntradaDeSo;

{************************************************}
implementation
{************************************************}

uses Forms, MMSystem, UnitDades;

type
  PSo = ^So;
  So = array[0..MaximBytesBufferEntradaDeSo] of Byte;
  //So = array[1..MaximBytesBufferEntradaDeSo] of Byte;

var
  so1,so2:PSo;
  Entrada:HWAVEIN;
  Cabecera1,Cabecera2:TWaveHdr;
  TPCMFormato:TWaveFormatEx;
  NumeroBufer:byte;

{************************************************}
procedure Pausa(t:integer);
var
  TheTime:LongInt;
begin
  TheTime:=GetTickCount+t;
  while GetTickCount<TheTime do Application.ProcessMessages;
end;

{************************************************}
//03 Ho he canviat de Functiona Procedure ja que no feis servir el resultat de tornada
Procedure IniciarDadesEntradaDeSo;
begin
  new(So1);
  new(So2);
end;

function EngegarProcesEntradaDeSo(HWindow:HWnd):integer;
var
  i:LongInt;
  Rerror:integer;
begin
  EngegarProcesEntradaDeSo:=0;
  if Entrada<>0 then exit;
  if FrequenciaDeMostreigEntradaSo=22050 then begin
    GrandariaBytesBufferEntradaDeSo:=2*GrandariaBytesBufferEntradaDeSo;
    //NumeroMaximValorsFuncioDesfasada:=2*NumeroMaximValorsFuncioDesfasada;
  end else if FrequenciaDeMostreigEntradaSo=44100 then begin
    GrandariaBytesBufferEntradaDeSo:=4*GrandariaBytesBufferEntradaDeSo;
    //NumeroMaximValorsFuncioDesfasada:=4*NumeroMaximValorsFuncioDesfasada;
  end;
  GrandariaNumerosBufferEntradaDeSo:=GrandariaBytesBufferEntradaDeSo;
  if BitsPerMostraEntradaSo=16 then GrandariaBytesBufferEntradaDeSo:=2*GrandariaBytesBufferEntradaDeSo;
  TPCMFormato.wFormatTag:= WAVE_FORMAT_PCM;
  TPCMFormato.nChannels:=CanalsEntradaSo;
  TPCMFormato.nSamplesPerSec:=FrequenciaDeMostreigEntradaSo;
  TPCMFormato.wBitsPerSample:=BitsPerMostraEntradaSo;
  TPCMFormato.nAvgBytesPerSec:=Round(FrequenciaDeMostreigEntradaSo*(BitsPerMostraEntradaSo/8)*CanalsEntradaSo);
  TPCMFormato.nBlockAlign:=Round((BitsPerMostraEntradaSo/8)*CanalsEntradaSo);
  TPCMFormato.cbSize:=0;
  Cabecera1.dwFlags:=0;
  Cabecera1.lpData:=@(So1^);
  Cabecera1.dwBufferLength:=GrandariaBytesBufferEntradaDeSo;
  Cabecera2.dwFlags:=0;
  Cabecera2.lpData:=@(So2^);
  Cabecera2.dwBufferLength:=GrandariaBytesBufferEntradaDeSo;
  Entrada:=0;
  Rerror:=waveInOpen(@Entrada, 0,@TPCMFormato,HWindow, 0, CALLBACK_WINDOW);
  if Rerror<>0 then begin
    EngegarProcesEntradaDeSo:=Rerror;
    MessageBox(HWindow,'NO puc obrir els dispositiu d''entrada','Captura so del micrfon', mb_Ok or MB_ICONSTOP);
    Exit;
  end;
  {
  if BitsPerMostraEntradaSo=16 then begin
    For i:=0 to MaximBytesBufferEntradaDeSo do begin
      so1^[i]:=0;
      so2^[i]:=0;
      NumerosEntradaDeSo[i]:=0;
    end;
  end else begin
  }
    For i:=0 to MaximNumerosBufferEntradaDeSo do begin
    //For i:=1 to MaximNumerosBufferEntradaDeSo do begin
      so1^[i]:=127;
      so2^[i]:=127;
      //NumerosEntradaDeSo[i]:=0;
      NumerosEntradaDeSo[i+1]:=0;
    end;
  //end;
  ParoProcesContinuEntradaDeSo:=false;
  waveInPrepareHeader(Entrada,@Cabecera1,sizeof(TWaveHdr));
  waveInAddBuffer(Entrada,@Cabecera1,sizeof(TWaveHdr));
  NumeroBufer:=1;
  waveInPrepareHeader(Entrada,@Cabecera2,sizeof(TWaveHdr));
  waveInAddBuffer(Entrada,@Cabecera2,sizeof(TWaveHdr));
  NumeroBufer:=2;
  waveInStart(Entrada);
end;

function ValorMaximDetectatEntradaDeSo:integer;
var
  i,Max,Comodi:integer;
begin
  ValorMaximDetectatEntradaDeSo:=0;
  if not ParoProcesContinuEntradaDeSo then begin
    if NumeroBufer=2 then begin
      if BitsPerMostraEntradaSo=8 then begin
        For i:=0 to GrandariaNumerosBufferEntradaDeSo-1 do NumerosEntradaDeSo[i+1]:=so1^[i]-127;
        //For i:=1 to GrandariaNumerosBufferEntradaDeSo do NumerosEntradaDeSo[i]:=so1^[i]-127;
      end else begin
        For i:=0 to GrandariaNumerosBufferEntradaDeSo-1 do begin
        //For i:=1 to GrandariaNumerosBufferEntradaDeSo do begin
          if so1^[2*i]>127 then Comodi:= 256-so1^[2*i] else Comodi:= -so1^[2*i];
          if so1^[2*i+1]>127 then Comodi:= -(Comodi+(256-so1^[2*i+1])*256) else Comodi:= -(Comodi-so1^[2*i+1]*256);
          NumerosEntradaDeSo[i+1]:=Comodi;
          //NumerosEntradaDeSo[i]:=Comodi;
        end;
      end;
    end else begin
      if BitsPerMostraEntradaSo=8 then begin
        For i:=0 to GrandariaNumerosBufferEntradaDeSo-1 do NumerosEntradaDeSo[i+1]:=so2^[i]-127;
        //For i:=1 to GrandariaNumerosBufferEntradaDeSo do NumerosEntradaDeSo[i]:=so2^[i]-127;
      end else begin
        For i:=0 to GrandariaNumerosBufferEntradaDeSo-1 do begin
        //For i:=1 to GrandariaNumerosBufferEntradaDeSo do begin
          if so2^[2*i]>127 then Comodi:= 256-so2^[2*i] else Comodi:= -so2^[2*i];
          if so2^[2*i+1]>127 then Comodi:= -(Comodi+(256-so2^[2*i+1])*256) else Comodi:= -(Comodi-so2^[2*i+1]*256);
          NumerosEntradaDeSo[i+1]:=Comodi;
          //NumerosEntradaDeSo[i]:=Comodi;
        end;
      end;
    end;
    Max:=0;
    For i:=1 to GrandariaNumerosBufferEntradaDeSo do if NumerosEntradaDeSo[i]>Max then Max:=NumerosEntradaDeSo[i];
    ValorMaximDetectatEntradaDeSo:=Max;
    if NumeroBufer=2 then begin
      waveInAddBuffer(Entrada,@Cabecera1,sizeof(TWaveHdr));
      NumeroBufer:=1;
    end else begin
      waveInAddBuffer(Entrada,@Cabecera2,sizeof(TWaveHdr));
      NumeroBufer:=2;
    end;
  end;
end;

procedure PararEntradaDeSo;
begin
  ParoProcesContinuEntradaDeSo:=true;
  waveInReset(Entrada);
  waveInClose(Entrada);
  Entrada:=0;
end;

procedure FinalitzarEntradaDeSo;
begin
  PararEntradaDeSo;
  //pausa(1000);
  Dispose(So2);
  Dispose(So1);
end;

{************************************************}
end.
